#!/bin/sh

DPLY_PAGE_INFRA_SELECT_RESULT_OK=0
DPLY_PAGE_INFRA_SELECT_RESULT_ERROR=1
DPLY_PAGE_INFRA_SELECT_RESULT_CODE=${DPLY_PAGE_INFRA_SELECT_RESULT_ERROR}

DPLY_PAGE_INFRA_SELECT_RESULT_MSG=""
DPLY_PAGE_INFRA_SELECT_RESULT_ROLLING=0

dply_page_infra_select() {
	debug_print "${0}" "${LINENO}" 'in function "dply_page_infra_select"'
	
	tp_yesno \
		"${DPLY_PAGE_INFRA_SELECT_TITLE}" \
		"${DPLY_PAGE_INFRA_SELECT_TEXT}" \
		"${DPLY_PAGE_INFRA_SELECT_LABEL_OK}" \
		"${DPLY_PAGE_INFRA_SELECT_LABEL_CANCEL}"

    if [ "${TP_YESNO_RESULT_CODE}" == "${TP_YESNO_RESULT_ERROR}" ]; then
		DPLY_PAGE_INFRA_SELECT_RESULT_CODE=$DPLY_PAGE_INFRA_SELECT_RESULT_ERROR
		DPLY_PAGE_INFRA_SELECT_RESULT_ROLLING=0
		DPLY_PAGE_INFRA_SELECT_RESULT_MSG="${DPLY_PAGE_INFRA_SELECT_ERROR_UNKNOWN}"
        return
    fi
        

    case "${TP_YESNO_RESULT_SELECT}" in
	
		# user press "Single"
		"${TP_YESNO_RESULT_YES}")
			RT_MASTER_MODE=1

			# save and error handling
			utility_save_infra_conf "${RT_MASTER_MODE}"
			if [ "${?}" -ne 0 ]; then
				DPLY_PAGE_INFRA_SELECT_RESULT_CODE=$DPLY_PAGE_INFRA_SELECT_RESULT_ERROR
				DPLY_PAGE_INFRA_SELECT_RESULT_ROLLING=0
				DPLY_PAGE_INFRA_SELECT_RESULT_MSG="${DPLY_PAGE_INFRA_SELECT_ERROR_SAVE_CONFIGURATION}"
				return 
			fi
			
            # save successfully
			DPLY_PAGE_INFRA_SELECT_RESULT_CODE=$DPLY_PAGE_INFRA_SELECT_RESULT_OK
			DPLY_PAGE_INFRA_SELECT_RESULT_ROLLING=2
            DPLY_PAGE_INFRA_SELECT_RESULT_MSG=""
			;;
		
		# user press "Multiple"
		"${TP_YESNO_RESULT_NO}")
		
			# go to PAGE_MODE_SELECT
			DPLY_PAGE_INFRA_SELECT_RESULT_CODE=$DPLY_PAGE_INFRA_SELECT_RESULT_OK
			DPLY_PAGE_INFRA_SELECT_RESULT_ROLLING=1
			DPLY_PAGE_INFRA_SELECT_RESULT_MSG=""
			;;
			
		*)
			DPLY_PAGE_INFRA_SELECT_RESULT_CODE=$DPLY_PAGE_INFRA_SELECT_RESULT_ERROR
			DPLY_PAGE_INFRA_SELECT_RESULT_ROLLING=0
			DPLY_PAGE_INFRA_SELECT_RESULT_MSG="${DPLY_PAGE_INFRA_SELECT_ERROR_UNKNOWN}"
			;;
	esac
}
